#ifndef RWEXPERROR_H
#define RWEXPERROR_H

#include <string>

class RwExpError
//Throw an object this class when an fatal error occurs during export.
//It will be caught in the SceneExport method, display a dialog with the explanation text
//and exit gracefully.
{
public:
    RwExpError( std::string explanation ) : m_explanation( explanation ), m_displayed(false) {}
	std::string Explanation() { return m_explanation; }

    void Display();

private:
	std::string m_explanation;
    bool m_displayed;

	//don't make errors without an explanation!!!
	RwExpError();
};

#endif

